USE [V5_Registry]
GO

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_PADDING ON
GO

CREATE TABLE [MSSR].[MSSR_DSS_ALBCC](
	[sta3n] [smallint] NULL,
	[visn] [tinyint] NULL,
	[sta6a] [varchar](6) NULL,
	[fy] [smallint] NULL,
	[fp] [smallint] NULL,
	[produnit] [varchar](2) NULL,
	[exempt] [varchar](1) NULL,
	[albcc] [varchar](10) NULL,
	[albacct] [varchar](11) NULL,
	[costtyp] [varchar](3) NULL,
	[catnum] [varchar](2) NULL,
	[edi] [varchar](1) NULL,
	[active] [varchar](1) NULL,
	[actualdollars] [numeric](20, 6) NULL,
	[reg_dllr] [numeric](20, 6) NULL,
	[vsh_dllr] [numeric](20, 6) NULL,
	[ot_dllr] [numeric](20, 6) NULL,
	[actualhours] [int] NULL,
	[reg_hour] [int] NULL,
	[vsh_hour] [int] NULL,
	[ot_hour] [int] NULL,
	[ipd] [varchar](10) NULL,
	[ipddesc] [varchar](30) NULL,
	[cendesc] [varchar](30) NULL,
	[actdesc] [varchar](30) NULL,
	[cc] [varchar](3) NULL,
	[boc] [varchar](4) NULL,
	[bud_dllr] [numeric](20, 6) NULL,
	[bud_hour] [int] NULL,
	[fb_dllr] [numeric](20, 6) NULL,
	[fb_hour] [int] NULL,
	[fv_dllr] [numeric](20, 6) NULL,
	[fv_hour] [int] NULL,
	[var_dllr] [numeric](20, 6) NULL,
	[var_hour] [int] NULL,
	[visn_plc] [varchar](4) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_DSS_ALBHR](
	[sta3n] [smallint] NULL,
	[visn] [tinyint] NULL,
	[fy] [smallint] NULL,
	[fp] [smallint] NULL,
	[sta6a] [varchar](6) NULL,
	[albcc] [varchar](10) NULL,
	[produnit] [varchar](2) NULL,
	[albacct] [varchar](11) NULL,
	[work_hrs] [int] NULL,
	[work_dllr] [numeric](20, 6) NULL,
	[ot_hour] [int] NULL,
	[ot_dllr] [numeric](20, 6) NULL,
	[vsh_hour] [int] NULL,
	[vsh_dllr] [numeric](20, 6) NULL,
	[cc] [varchar](3) NULL,
	[boc] [varchar](4) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_DSS_ATTEND](
	[sta3n] [smallint] NULL,
	[visn] [tinyint] NULL,
	[sta6a] [varchar](6) NULL,
	[fy] [smallint] NULL,
	[fp] [smallint] NULL,
	[encno] [varchar](11) NULL,
	[admitday] [date] NULL,
	[disday] [date] NULL,
	[beginday] [date] NULL,
	[endday] [date] NULL,
	[rectype] [varchar](1) NULL,
	[atend] [varchar](11) NULL,
	[atendtyp] [varchar](7) NULL,
	[beddaysmd] [int] NULL,
	[txsp] [varchar](2) NULL,
	[txspedt] [date] NULL,
	[div] [varchar](6) NULL,
	[enc_num] [varchar](11) NULL,
	[bdt] [date] NULL,
	[edt] [date] NULL,
	[rectyp] [varchar](4) NULL,
	[bed] [int] NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_DSS_CHAR4](
	[sta3n] [smallint] NULL,
	[visn] [tinyint] NULL,
	[fy] [smallint] NULL,
	[fp] [smallint] NULL,
	[encno] [varchar](11) NULL,
	[scrssn] [varchar](9) NULL,
	[sta6a] [varchar](6) NULL,
	[pseudo] [varchar](1) NULL,
	[vizday] [date] NULL,
	[stop] [varchar](3) NULL,
	[credit] [varchar](3) NULL,
	[fdrkey] [varchar](30) NULL,
	[char4] [varchar](4) NULL,
	[divp] [varchar](6) NULL,
	[fxdir] [numeric](20, 6) NULL,
	[fxind] [numeric](20, 6) NULL,
	[var] [numeric](20, 6) NULL,
	[volume] [numeric](20, 6) NULL,
	[vl4] [numeric](20, 6) NULL,
	[vl5] [numeric](20, 6) NULL,
	[vs] [numeric](20, 6) NULL,
	[ref_flg] [varchar](1) NULL,
	[tmed] [varchar](4) NULL,
	[oefoif] [varchar](1) NULL,
	[oefoifdte] [date] NULL,
	[tcost] [numeric](20, 6) NULL,
	[dss_id] [varchar](6) NULL,
	[veteran] [varchar](1) NULL,
	[pt] [varchar](2) NULL,
	[encelig] [varchar](3) NULL,
	[appttype] [varchar](2) NULL,
	[provtype] [varchar](7) NULL,
	[patcat] [varchar](5) NULL,
	[dod_flag] [varchar](1) NULL,
	[mpi] [varchar](10) NULL,
	[eligibility] [varchar](3) NULL,
	[ps] [varchar](4) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_DSS_DDC](
	[sta3n] [smallint] NULL,
	[scrssn] [varchar](9) NULL,
	[visn] [tinyint] NULL,
	[fy] [smallint] NULL,
	[fp] [smallint] NULL,
	[encno] [varchar](11) NULL,
	[name] [varchar](4) NULL,
	[date] [date] NULL,
	[quantity] [int] NULL,
	[cpt] [varchar](8) NULL,
	[vahcpc] [varchar](8) NULL,
	[elg] [varchar](3) NULL,
	[cost] [numeric](20, 6) NULL,
	[ddcsta] [varchar](6) NULL,
	[rdt] [date] NULL,
	[oefoif] [varchar](1) NULL,
	[oefoifdte] [date] NULL,
	[dod_flag] [varchar](1) NULL,
	[mpi] [varchar](10) NULL,
	[patcat] [varchar](5) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_DSS_DISCH](
	[sta3n] [smallint] NULL,
	[scrssn] [varchar](9) NULL,
	[visn] [tinyint] NULL,
	[sta6a] [varchar](6) NULL,
	[fy] [smallint] NULL,
	[fp] [smallint] NULL,
	[encno] [varchar](11) NULL,
	[admitday] [date] NULL,
	[disday] [date] NULL,
	[drgms] [smallint] NULL,
	[pcp] [varchar](11) NULL,
	[pcptype] [varchar](7) NULL,
	[age] [smallint] NULL,
	[sex] [varchar](1) NULL,
	[dtxsp] [varchar](2) NULL,
	[picd9] [varchar](6) NULL,
	[admicd9] [varchar](7) NULL,
	[addrg] [smallint] NULL,
	[enrpriority] [varchar](2) NULL,
	[discdisp] [varchar](2) NULL,
	[discplace] [varchar](2) NULL,
	[los] [int] NULL,
	[aggabsdays] [int] NULL,
	[nsgfd] [numeric](20, 6) NULL,
	[nsgfi] [numeric](20, 6) NULL,
	[nsgvd] [numeric](20, 6) NULL,
	[nsgbdoc] [int] NULL,
	[surgfd] [numeric](20, 6) NULL,
	[surgfi] [numeric](20, 6) NULL,
	[surgvd] [numeric](20, 6) NULL,
	[surgdays] [int] NULL,
	[labfd] [numeric](20, 6) NULL,
	[labfi] [numeric](20, 6) NULL,
	[labvd] [numeric](20, 6) NULL,
	[labtests] [int] NULL,
	[radfd] [numeric](20, 6) NULL,
	[radfi] [numeric](20, 6) NULL,
	[radvd] [numeric](20, 6) NULL,
	[radprocs] [int] NULL,
	[rxfd] [numeric](20, 6) NULL,
	[rxfi] [numeric](20, 6) NULL,
	[rxvd] [numeric](20, 6) NULL,
	[othfd] [numeric](20, 6) NULL,
	[othfi] [numeric](20, 6) NULL,
	[othvd] [numeric](20, 6) NULL,
	[rxvs] [numeric](20, 6) NULL,
	[surgvl4] [numeric](20, 6) NULL,
	[surgvl5] [numeric](20, 6) NULL,
	[radvl4] [numeric](20, 6) NULL,
	[radvl5] [numeric](20, 6) NULL,
	[othvl4] [numeric](20, 6) NULL,
	[othvl5] [numeric](20, 6) NULL,
	[surgimp] [numeric](20, 6) NULL,
	[pt] [varchar](2) NULL,
	[oefoif] [varchar](1) NULL,
	[oefoifdte] [date] NULL,
	[addrgms] [smallint] NULL,
	[nsgtot] [numeric](20, 6) NULL,
	[surgtot] [numeric](20, 6) NULL,
	[labtot] [numeric](20, 6) NULL,
	[radtot] [numeric](20, 6) NULL,
	[rxtot] [numeric](20, 6) NULL,
	[othtot] [numeric](20, 6) NULL,
	[totfd] [numeric](20, 6) NULL,
	[totfi] [numeric](20, 6) NULL,
	[totvd] [numeric](20, 6) NULL,
	[totcost] [numeric](20, 6) NULL,
	[dxprime] [varchar](6) NULL,
	[dxlsf] [varchar](6) NULL,
	[dob] [date] NULL,
	[ag8r] [int] NULL,
	[disch] [int] NULL,
	[days] [int] NULL,
	[fydays] [int] NULL,
	[a_pcp] [varchar](11) NULL,
	[a_pcptyp] [varchar](7) NULL,
	[dao_unt] [int] NULL,
	[dhomeox] [numeric](20, 6) NULL,
	[dpha_unt] [int] NULL,
	[dprolbr] [numeric](20, 6) NULL,
	[dprosupl] [numeric](20, 6) NULL,
	[extdte] [date] NULL,
	[dischmd] [varchar](11) NULL,
	[dismdnpi] [varchar](15) NULL,
	[dismdpt] [varchar](7) NULL,
	[dod_flag] [varchar](1) NULL,
	[mpi] [varchar](10) NULL,
	[opadmit] [varchar](1) NULL,
	[patcat] [varchar](5) NULL,
	[eligibility] [varchar](3) NULL,
	[ps] [varchar](4) NULL,
	[eddisp] [varchar](1) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_DSS_ECS](
	[sta3n] [smallint] NULL,
	[scrssn] [varchar](9) NULL,
	[visn] [tinyint] NULL,
	[sta6a] [varchar](6) NULL,
	[fy] [smallint] NULL,
	[fp] [smallint] NULL,
	[encno] [varchar](11) NULL,
	[inout] [varchar](1) NULL,
	[admitday] [date] NULL,
	[disday] [date] NULL,
	[txsp] [varchar](2) NULL,
	[vizday] [date] NULL,
	[dob] [date] NULL,
	[sex] [varchar](1) NULL,
	[means] [varchar](2) NULL,
	[zip4] [varchar](10) NULL,
	[pct] [varchar](4) NULL,
	[pcp] [varchar](11) NULL,
	[dx] [varchar](6) NULL,
	[enrlp] [varchar](2) NULL,
	[provt] [varchar](7) NULL,
	[stop] [varchar](3) NULL,
	[date] [date] NULL,
	[time] [time](0) NULL,
	[ward] [varchar](6) NULL,
	[ipd] [varchar](10) NULL,
	[fdrloc] [varchar](10) NULL,
	[fdrkey] [varchar](30) NULL,
	[ip] [int] NULL,
	[pname] [varchar](25) NULL,
	[quantity] [int] NULL,
	[tcost] [numeric](20, 6) NULL,
	[divp] [varchar](6) NULL,
	[prov] [varchar](11) NULL,
	[fixdir] [numeric](20, 6) NULL,
	[fixind] [numeric](20, 6) NULL,
	[var] [numeric](20, 6) NULL,
	[vl1] [numeric](20, 6) NULL,
	[vl2] [numeric](20, 6) NULL,
	[vl4] [numeric](20, 6) NULL,
	[vl5] [numeric](20, 6) NULL,
	[vsup] [numeric](20, 6) NULL,
	[county] [varchar](5) NULL,
	[credit] [varchar](3) NULL,
	[prov2] [varchar](11) NULL,
	[prov3] [varchar](11) NULL,
	[provt2] [varchar](7) NULL,
	[provt3] [varchar](7) NULL,
	[oefoif] [varchar](1) NULL,
	[oefoifdte] [date] NULL,
	[div] [varchar](6) NULL,
	[dod_flag] [varchar](1) NULL,
	[mpi] [varchar](10) NULL,
	[patcat] [varchar](5) NULL,
	[char4] [varchar](4) NULL,
	[secprov1] [varchar](11) NULL,
	[secpr1pt] [varchar](7) NULL,
	[secpr1npi] [varchar](10) NULL,
	[secprov2] [varchar](11) NULL,
	[secpr2pt] [varchar](7) NULL,
	[secpr2npi] [varchar](10) NULL,
	[secprov3] [varchar](11) NULL,
	[secpr3pt] [varchar](7) NULL,
	[secpr3npi] [varchar](10) NULL,
	[secprov4] [varchar](11) NULL,
	[secpr4pt] [varchar](7) NULL,
	[secpr4npi] [varchar](10) NULL,
	[secprov5] [varchar](11) NULL,
	[secpr5pt] [varchar](7) NULL,
	[secpr5npi] [varchar](10) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_DSS_NOSHOW](
	[sta3n] [smallint] NULL,
	[scrssn] [varchar](9) NULL,
	[visn] [tinyint] NULL,
	[sta6a] [varchar](6) NULL,
	[fy] [smallint] NULL,
	[fp] [smallint] NULL,
	[encno] [varchar](11) NULL,
	[vizday] [date] NULL,
	[stop] [varchar](3) NULL,
	[credit] [varchar](3) NULL,
	[enrlprty] [varchar](2) NULL,
	[veteran] [varchar](1) NULL,
	[pt] [varchar](2) NULL,
	[clnm] [varchar](6) NULL,
	[rdt] [date] NULL,
	[oefoif] [varchar](1) NULL,
	[oefoifdte] [date] NULL,
	[dss_id] [varchar](6) NULL,
	[noshow] [varchar](1) NULL,
	[pseudo] [varchar](1) NULL,
	[stops] [int] NULL,
	[dod_flag] [varchar](1) NULL,
	[mpi] [varchar](10) NULL,
	[patcat] [varchar](5) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_DSS_OBT](
	[sta3n] [smallint] NULL,
	[scrssn] [varchar](9) NULL,
	[encno] [varchar](11) NULL,
	[visn] [tinyint] NULL,
	[sta6a] [varchar](6) NULL,
	[fy] [smallint] NULL,
	[fp] [smallint] NULL,
	[pcp] [varchar](11) NULL,
	[pcptype] [varchar](7) NULL,
	[admicd9] [varchar](7) NULL,
	[admdrg] [varchar](3) NULL,
	[admitday] [date] NULL,
	[disday] [date] NULL,
	[aggabsdays] [int] NULL,
	[enrpriority] [varchar](4) NULL,
	[sex] [varchar](1) NULL,
	[age] [smallint] NULL,
	[veteran] [varchar](1) NULL,
	[rdt] [date] NULL,
	[txsp] [varchar](2) NULL,
	[txspsdt] [date] NULL,
	[txspedt] [date] NULL,
	[txspstm] [time](0) NULL,
	[txspetm] [time](0) NULL,
	[nsgfd] [numeric](20, 6) NULL,
	[nsgfi] [numeric](20, 6) NULL,
	[nsgvd] [numeric](20, 6) NULL,
	[nsgunits] [int] NULL,
	[surgfd] [numeric](20, 6) NULL,
	[surgfi] [numeric](20, 6) NULL,
	[surgvd] [numeric](20, 6) NULL,
	[surgunits] [int] NULL,
	[labfd] [numeric](20, 6) NULL,
	[labfi] [numeric](20, 6) NULL,
	[labvd] [numeric](20, 6) NULL,
	[labunits] [int] NULL,
	[radfd] [numeric](20, 6) NULL,
	[radfi] [numeric](20, 6) NULL,
	[radvd] [numeric](20, 6) NULL,
	[radunits] [int] NULL,
	[rxfd] [numeric](20, 6) NULL,
	[rxfi] [numeric](20, 6) NULL,
	[rxvd] [numeric](20, 6) NULL,
	[othfd] [numeric](20, 6) NULL,
	[othfi] [numeric](20, 6) NULL,
	[othvd] [numeric](20, 6) NULL,
	[rxvs] [numeric](20, 6) NULL,
	[surgvl4] [numeric](20, 6) NULL,
	[surgvl5] [numeric](20, 6) NULL,
	[radvl4] [numeric](20, 6) NULL,
	[radvl5] [numeric](20, 6) NULL,
	[othvl4] [numeric](20, 6) NULL,
	[othvl5] [numeric](20, 6) NULL,
	[surgimp] [numeric](20, 6) NULL,
	[ho2] [numeric](20, 6) NULL,
	[pt] [varchar](2) NULL,
	[oefoif] [varchar](1) NULL,
	[oefoifdte] [date] NULL,
	[drgms] [smallint] NULL,
	[nsgtot] [numeric](20, 6) NULL,
	[surgtot] [numeric](20, 6) NULL,
	[labtot] [numeric](20, 6) NULL,
	[radtot] [numeric](20, 6) NULL,
	[rxtot] [numeric](20, 6) NULL,
	[othtot] [numeric](20, 6) NULL,
	[totfd] [numeric](20, 6) NULL,
	[totfi] [numeric](20, 6) NULL,
	[totvd] [numeric](20, 6) NULL,
	[totcost] [numeric](20, 6) NULL,
	[prolab] [numeric](20, 6) NULL,
	[prosup] [numeric](20, 6) NULL,
	[patcat] [varchar](5) NULL,
	[dod_flag] [varchar](1) NULL,
	[mpi] [varchar](10) NULL,
	[eligibility] [varchar](3) NULL,
	[ps] [varchar](4) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_DSS_OCRED](
	[sta3n] [smallint] NULL,
	[scrssn] [varchar](9) NULL,
	[visn] [tinyint] NULL,
	[sta6a] [varchar](6) NULL,
	[fy] [smallint] NULL,
	[fp] [smallint] NULL,
	[encno] [varchar](11) NULL,
	[pseudo] [varchar](1) NULL,
	[vizday] [date] NULL,
	[stop] [varchar](3) NULL,
	[credit] [varchar](3) NULL,
	[divp] [varchar](6) NULL,
	[fxdir] [numeric](20, 6) NULL,
	[fxind] [numeric](20, 6) NULL,
	[var] [numeric](20, 6) NULL,
	[volume] [numeric](20, 6) NULL,
	[wardbdoc] [int] NULL,
	[ipdbdoc] [int] NULL,
	[vl4] [numeric](20, 6) NULL,
	[vl5] [numeric](20, 6) NULL,
	[vs] [numeric](20, 6) NULL,
	[tmed] [varchar](4) NULL,
	[oefoif] [varchar](1) NULL,
	[oefoifdte] [date] NULL,
	[tcost] [numeric](20, 6) NULL,
	[dss_id] [varchar](6) NULL,
	[dod_flag] [varchar](1) NULL,
	[mpi] [varchar](10) NULL,
	[patcat] [varchar](5) NULL,
	[pt] [varchar](2) NULL,
	[eligibility] [varchar](3) NULL,
	[ps] [varchar](4) NULL	
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_DSS_OIPD](
	[sta3n] [smallint] NULL,
	[scrssn] [varchar](9) NULL,
	[visn] [tinyint] NULL,
	[sta6a] [varchar](6) NULL,
	[fy] [smallint] NULL,
	[fp] [smallint] NULL,
	[encno] [varchar](11) NULL,
	[pseudo] [varchar](1) NULL,
	[vizday] [date] NULL,
	[stop] [varchar](3) NULL,
	[credit] [varchar](3) NULL,
	[div] [varchar](3) NULL,
	[ipd] [varchar](10) NULL,
	[ipdfd] [numeric](20, 6) NULL,
	[ipdfi] [numeric](20, 6) NULL,
	[ipdvd] [numeric](20, 6) NULL,
	[volume] [numeric](20, 6) NULL,
	[wardbdoc] [int] NULL,
	[ipdbdoc] [int] NULL,
	[vl4] [numeric](20, 6) NULL,
	[vl5] [numeric](20, 6) NULL,
	[vs] [numeric](20, 6) NULL,
	[referlabflag] [varchar](1) NULL,
	[cmopflag] [varchar](1) NULL,
	[obsflag] [varchar](1) NULL,
	[telemedflag] [varchar](1) NULL,
	[oefoif] [varchar](1) NULL,
	[oefoifdte] [date] NULL,
	[totcost] [numeric](20, 6) NULL,
	[ipd_type] [varchar](1) NULL,
	[dss_id] [varchar](6) NULL,
	[pros_type] [varchar](1) NULL,
	[divperf] [varchar](6) NULL,
	[noshow] [varchar](1) NULL,
	[patcat] [varchar](5) NULL,
	[dod_flag] [varchar](1) NULL,
	[mpi] [varchar](10) NULL,
	[fmp] [varchar](2) NULL,
	[pt] [varchar](2) NULL,
	[eligibility] [varchar](3) NULL,
	[ps] [varchar](4) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_DSS_OUT](
	[sta3n] [smallint] NULL,
	[scrssn] [varchar](9) NULL,
	[visn] [tinyint] NULL,
	[sta6a] [varchar](6) NULL,
	[fy] [smallint] NULL,
	[fp] [smallint] NULL,
	[encno] [varchar](11) NULL,
	[pseudocode] [varchar](1) NULL,
	[vizday] [date] NULL,
	[stop] [varchar](3) NULL,
	[credit] [varchar](3) NULL,
	[age] [smallint] NULL,
	[sex] [varchar](1) NULL,
	[enrpriority] [varchar](2) NULL,
	[userenr] [varchar](1) NULL,
	[encelig] [varchar](3) NULL,
	[veteran] [varchar](1) NULL,
	[purpleheart] [varchar](1) NULL,
	[pow] [varchar](1) NULL,
	[powloc] [varchar](2) NULL,
	[ago] [varchar](1) NULL,
	[agoloc] [varchar](2) NULL,
	[agoenc] [varchar](1) NULL,
	[ionrad] [varchar](1) NULL,
	[ionradenc] [varchar](1) NULL,
	[envcont] [varchar](1) NULL,
	[envconenc] [varchar](1) NULL,
	[mst] [varchar](1) NULL,
	[mstenc] [varchar](1) NULL,
	[combat] [varchar](1) NULL,
	[zip] [varchar](10) NULL,
	[pt] [varchar](2) NULL,
	[cvenc] [varchar](1) NULL,
	[natptrecflag] [varchar](1) NULL,
	[headneck] [varchar](1) NULL,
	[appttype] [varchar](2) NULL,
	[povv] [varchar](2) NULL,
	[picd9] [varchar](9) NULL,
	[clinicname] [varchar](6) NULL,
	[prov] [varchar](11) NULL,
	[provtype] [varchar](7) NULL,
	[pcteam] [varchar](4) NULL,
	[pcprov] [varchar](11) NULL,
	[npcdflag] [varchar](1) NULL,
	[cliflag] [varchar](1) NULL,
	[prosflag] [varchar](1) NULL,
	[preflag] [varchar](1) NULL,
	[utilbuiltflag] [varchar](1) NULL,
	[obsflag] [varchar](1) NULL,
	[comppenflag] [varchar](1) NULL,
	[telemedflag] [varchar](4) NULL,
	[vistacbocflag] [varchar](1) NULL,
	[vastcbocflag] [varchar](1) NULL,
	[contractcbocflag] [varchar](1) NULL,
	[referlabflag] [varchar](1) NULL,
	[cmopflag] [varchar](1) NULL,
	[race1] [varchar](6) NULL,
	[ethnicity] [varchar](6) NULL,
	[eligibility] [varchar](3) NULL,
	[dss_id] [varchar](6) NULL,
	[prostypeflag] [varchar](1) NULL,
	[acttotcost] [numeric](20, 6) NULL,
	[actdirectcost] [numeric](20, 6) NULL,
	[actindirectcost] [numeric](20, 6) NULL,
	[sur_vl4] [numeric](20, 6) NULL,
	[sur_vl5] [numeric](20, 6) NULL,
	[rad_vl4] [numeric](20, 6) NULL,
	[rad_vl5] [numeric](20, 6) NULL,
	[oth_vl4] [numeric](20, 6) NULL,
	[oth_vl5] [numeric](20, 6) NULL,
	[surg_imp] [numeric](20, 6) NULL,
	[home_o2] [numeric](20, 6) NULL,
	[rdt] [date] NULL,
	[county] [varchar](5) NULL,
	[oefoif] [varchar](1) NULL,
	[oefoifdte] [date] NULL,
	[stops] [int] NULL,
	[hcup] [varchar](3) NULL,
	[volume] [numeric](20, 2) NULL,
	[pcprovtype] [varchar](7) NULL,
	[dd_sup] [numeric](20, 6) NULL,
	[noshow] [varchar](1) NULL,
	[pros_lab] [numeric](20, 6) NULL,
	[pros_sup] [numeric](20, 6) NULL,
	[primcpt4] [varchar](8) NULL,
	[feeder_key] [varchar](20) NULL,
	[hbpc] [int] NULL,
	[dod_flag] [varchar](1) NULL,
	[fmp] [varchar](2) NULL,
	[mpi] [varchar](10) NULL,
	[patcat] [varchar](5) NULL,
	[varsupplycost] [numeric](20, 6) NULL,
	[actvardirectcost] [numeric](20, 6) NULL,
	[provnpi] [varchar](10) NULL,
	[pcpnpi] [varchar](10) NULL,
	[ps] [varchar](4) NULL,
	[secprov1] [varchar](11) NULL,
	[secpr1pt] [varchar](7) NULL,
	[secpr1npi] [varchar](10) NULL,
	[secprov2] [varchar](11) NULL,
	[secpr2pt] [varchar](7) NULL,
	[secpr2npi] [varchar](10) NULL,
	[secprov3] [varchar](11) NULL,
	[secpr3pt] [varchar](7) NULL,
	[secpr3npi] [varchar](10) NULL,
	[secprov4] [varchar](11) NULL,
	[secpr4pt] [varchar](7) NULL,
	[secpr4npi] [varchar](10) NULL,
	[secprov5] [varchar](11) NULL,
	[secpr5pt] [varchar](7) NULL,
	[secpr5npi] [varchar](10) NULL,
	[eddisp] [varchar](1) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_DSS_OUT2](
	[sta3n] [smallint] NULL,
	[scrssn] [varchar](9) NULL,
	[visn] [tinyint] NULL,
	[sta6a] [varchar](6) NULL,
	[fy] [smallint] NULL,
	[fp] [smallint] NULL,
	[encno] [varchar](11) NULL,
	[pseudocode] [varchar](1) NULL,
	[vizday] [date] NULL,
	[stop] [varchar](3) NULL,
	[credit] [varchar](3) NULL,
	[age] [smallint] NULL,
	[sex] [varchar](1) NULL,
	[enrpriority] [varchar](2) NULL,
	[userenr] [varchar](1) NULL,
	[encelig] [varchar](3) NULL,
	[veteran] [varchar](1) NULL,
	[purpleheart] [varchar](1) NULL,
	[pow] [varchar](1) NULL,
	[powloc] [varchar](2) NULL,
	[ago] [varchar](1) NULL,
	[agoloc] [varchar](2) NULL,
	[agoenc] [varchar](1) NULL,
	[ionrad] [varchar](1) NULL,
	[ionradenc] [varchar](1) NULL,
	[envcont] [varchar](1) NULL,
	[envconenc] [varchar](1) NULL,
	[mst] [varchar](1) NULL,
	[mstenc] [varchar](1) NULL,
	[combat] [varchar](1) NULL,
	[zip] [varchar](10) NULL,
	[pt] [varchar](2) NULL,
	[cvenc] [varchar](1) NULL,
	[natptrecflag] [varchar](1) NULL,
	[headneck] [varchar](1) NULL,
	[appttype] [varchar](2) NULL,
	[povv] [varchar](2) NULL,
	[picd9] [varchar](9) NULL,
	[clinicname] [varchar](6) NULL,
	[prov] [varchar](11) NULL,
	[provtype] [varchar](7) NULL,
	[pcteam] [varchar](4) NULL,
	[pcprov] [varchar](11) NULL,
	[npcdflag] [varchar](1) NULL,
	[cliflag] [varchar](1) NULL,
	[prosflag] [varchar](1) NULL,
	[preflag] [varchar](1) NULL,
	[utilbuiltflag] [varchar](1) NULL,
	[obsflag] [varchar](1) NULL,
	[comppenflag] [varchar](1) NULL,
	[telemedflag] [varchar](4) NULL,
	[vistacbocflag] [varchar](1) NULL,
	[vastcbocflag] [varchar](1) NULL,
	[contractcbocflag] [varchar](1) NULL,
	[referlabflag] [varchar](1) NULL,
	[cmopflag] [varchar](1) NULL,
	[race1] [varchar](6) NULL,
	[ethnicity] [varchar](6) NULL,
	[eligibility] [varchar](3) NULL,
	[dss_id] [varchar](6) NULL,
	[prostypeflag] [varchar](1) NULL,
	[acttotcost] [numeric](20, 6) NULL,
	[actdirectcost] [numeric](20, 6) NULL,
	[actindirectcost] [numeric](20, 6) NULL,
	[sur_vl4] [numeric](20, 6) NULL,
	[sur_vl5] [numeric](20, 6) NULL,
	[rad_vl4] [numeric](20, 6) NULL,
	[rad_vl5] [numeric](20, 6) NULL,
	[oth_vl4] [numeric](20, 6) NULL,
	[oth_vl5] [numeric](20, 6) NULL,
	[surg_imp] [numeric](20, 6) NULL,
	[home_o2] [numeric](20, 6) NULL,
	[rdt] [date] NULL,
	[county] [varchar](5) NULL,
	[oefoif] [varchar](1) NULL,
	[oefoifdte] [date] NULL,
	[stops] [int] NULL,
	[hcup] [varchar](3) NULL,
	[volume] [numeric](20, 2) NULL,
	[pcprovtype] [varchar](7) NULL,
	[dd_sup] [numeric](20, 6) NULL,
	[noshow] [varchar](1) NULL,
	[pros_lab] [numeric](20, 6) NULL,
	[pros_sup] [numeric](20, 6) NULL,
	[primcpt4] [varchar](8) NULL,
	[feeder_key] [varchar](20) NULL,
	[hbpc] [int] NULL,
	[actvardirectcost] [numeric](20, 6) NULL,
	[dod_flag] [varchar](1) NULL,
	[fmp] [varchar](2) NULL,
	[mpi] [varchar](10) NULL,
	[patcat] [varchar](5) NULL,
	[varsupplycost] [numeric](20, 6) NULL,
	[provnpi] [varchar](10) NULL,
	[pcpnpi] [varchar](10) NULL,
	[ps] [varchar](4) NULL,
	[secprov1] [varchar](11) NULL,
	[secpr1pt] [varchar](7) NULL,
	[secpr1npi] [varchar](10) NULL,
	[secprov2] [varchar](11) NULL,
	[secpr2pt] [varchar](7) NULL,
	[secpr2npi] [varchar](10) NULL,
	[secprov3] [varchar](11) NULL,
	[secpr3pt] [varchar](7) NULL,
	[secpr3npi] [varchar](10) NULL,
	[secprov4] [varchar](11) NULL,
	[secpr4pt] [varchar](7) NULL,
	[secpr4npi] [varchar](10) NULL,
	[secprov5] [varchar](11) NULL,
	[secpr5pt] [varchar](7) NULL,
	[secpr5npi] [varchar](10) NULL,
	[eddisp] [varchar](1) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_DSS_PHA](
	[sta3n] [smallint] NULL,
	[scrssn] [varchar](9) NULL,
	[visn] [tinyint] NULL,
	[sta6a] [varchar](6) NULL,
	[fy] [smallint] NULL,
	[fp] [smallint] NULL,
	[encno] [varchar](11) NULL,
	[svc_dte] [date] NULL,
	[inout] [varchar](1) NULL,
	[admitday] [date] NULL,
	[disday] [date] NULL,
	[txsp] [varchar](2) NULL,
	[ward] [varchar](6) NULL,
	[vizday] [date] NULL,
	[dob] [date] NULL,
	[sex] [varchar](1) NULL,
	[means] [varchar](2) NULL,
	[zip_4] [varchar](10) NULL,
	[enrlprty] [varchar](2) NULL,
	[county] [varchar](5) NULL,
	[pcteam] [varchar](4) NULL,
	[pcp_dss] [varchar](11) NULL,
	[stop] [varchar](3) NULL,
	[ipd] [varchar](10) NULL,
	[fdrloc] [varchar](10) NULL,
	[fdrkey] [varchar](30) NULL,
	[ip] [int] NULL,
	[cmop] [varchar](1) NULL,
	[day_supply] [int] NULL,
	[quantity] [int] NULL,
	[act_cost] [numeric](20, 6) NULL,
	[vs_cost] [numeric](20, 6) NULL,
	[dispcost] [numeric](20, 6) NULL,
	[divperf] [varchar](6) NULL,
	[ord_prov] [varchar](11) NULL,
	[ord_prov_type] [varchar](7) NULL,
	[invest] [varchar](1) NULL,
	[rxno] [varchar](9) NULL,
	[oefoif] [varchar](1) NULL,
	[oefoifdte] [date] NULL,
	[va_class] [varchar](5) NULL,
	[drugdesc] [varchar](63) NULL,
	[a_pcp] [varchar](12) NULL,
	[clsnum] [int] NULL,
	[patcat] [varchar](5) NULL,
	[dod_flag] [varchar](1) NULL,
	[mpi] [varchar](10) NULL,
	[fmp] [varchar](2) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_DSS_PROD](
	[visn] [tinyint] NULL,
	[sta3n] [smallint] NULL,
	[sta6a] [varchar](6) NULL,
	[fy] [smallint] NULL,
	[fp] [smallint] NULL,
	[ipd] [varchar](10) NULL,
	[ipddesc] [varchar](30) NULL,
	[ip] [int] NULL,
	[ipdesc] [varchar](25) NULL,
	[costtyp] [varchar](3) NULL,
	[catnum] [varchar](5) NULL,
	[rvu] [numeric](20, 8) NULL,
	[bud_vol] [int] NULL,
	[bud_dllr] [numeric](20, 6) NULL,
	[actualvol] [int] NULL,
	[actualdollars] [numeric](20, 6) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_DSS_RAD](
	[sta3n] [smallint] NULL,
	[scrssn] [varchar](9) NULL,
	[visn] [tinyint] NULL,
	[sta6a] [varchar](6) NULL,
	[fy] [smallint] NULL,
	[fp] [smallint] NULL,
	[encno] [varchar](11) NULL,
	[raddate] [date] NULL,
	[inout] [varchar](1) NULL,
	[admitday] [date] NULL,
	[disday] [date] NULL,
	[txsp] [varchar](2) NULL,
	[ward] [varchar](6) NULL,
	[vizday] [date] NULL,
	[dob] [date] NULL,
	[sex] [varchar](1) NULL,
	[meanstest] [varchar](2) NULL,
	[zip] [varchar](10) NULL,
	[enrpriority] [varchar](2) NULL,
	[county] [varchar](5) NULL,
	[pcteam] [varchar](4) NULL,
	[pcp] [varchar](11) NULL,
	[stop] [varchar](3) NULL,
	[ipd] [varchar](10) NULL,
	[fdrloc] [varchar](10) NULL,
	[fdrkey] [varchar](30) NULL,
	[ipnum] [int] NULL,
	[pcpt] [varchar](5) NULL,
	[procname] [varchar](25) NULL,
	[quantity] [int] NULL,
	[acttotcost] [numeric](20, 6) NULL,
	[varisuppcost] [numeric](20, 6) NULL,
	[timec] [time](0) NULL,
	[divperf] [varchar](6) NULL,
	[ordprov] [varchar](11) NULL,
	[ordprovtype] [varchar](7) NULL,
	[radfd] [numeric](20, 6) NULL,
	[radfi] [numeric](20, 6) NULL,
	[radvd] [numeric](20, 6) NULL,
	[oefoif] [varchar](1) NULL,
	[oefoifdte] [date] NULL,
	[a_pcp] [varchar](11) NULL,
	[dxcode] [varchar](9) NULL,
	[ipdno] [varchar](10) NULL,
	[rad_tot] [numeric](20, 6) NULL,
	[clsnum] [int] NULL,
	[patcat] [varchar](5) NULL,
	[dod_flag] [varchar](1) NULL,
	[mpi] [varchar](10) NULL,
	[fmp] [varchar](2) NULL,
	[crdmthd] [varchar](1) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_DSS_RAI](
	[sta3n] [smallint] NULL,
	[scrssn] [varchar](9) NULL,
	[visn] [tinyint] NULL,
	[sta6a] [varchar](6) NULL,
	[fy] [smallint] NULL,
	[fp] [smallint] NULL,
	[encno] [varchar](11) NULL,
	[pcp] [varchar](11) NULL,
	[pcpt] [varchar](7) NULL,
	[admicd9] [varchar](7) NULL,
	[admdrg] [varchar](3) NULL,
	[admitday] [date] NULL,
	[disday] [date] NULL,
	[aggabsdays] [int] NULL,
	[enrpriority] [varchar](2) NULL,
	[sex] [varchar](1) NULL,
	[age] [smallint] NULL,
	[veteran] [varchar](1) NULL,
	[rdt] [date] NULL,
	[rugsc] [varchar](3) NULL,
	[raisdt] [date] NULL,
	[raiedt] [date] NULL,
	[nsgfd] [numeric](20, 6) NULL,
	[nsgfi] [numeric](20, 6) NULL,
	[nsgvd] [numeric](20, 6) NULL,
	[nsgbdoc] [int] NULL,
	[surgfd] [numeric](20, 6) NULL,
	[surgfi] [numeric](20, 6) NULL,
	[surgvd] [numeric](20, 6) NULL,
	[surgdays] [int] NULL,
	[labfd] [numeric](20, 6) NULL,
	[labfi] [numeric](20, 6) NULL,
	[labvd] [numeric](20, 6) NULL,
	[labtests] [int] NULL,
	[radfd] [numeric](20, 6) NULL,
	[radfi] [numeric](20, 6) NULL,
	[radvd] [numeric](20, 6) NULL,
	[radprocs] [int] NULL,
	[rxfd] [numeric](20, 6) NULL,
	[rxfi] [numeric](20, 6) NULL,
	[rxvd] [numeric](20, 6) NULL,
	[othfd] [numeric](20, 6) NULL,
	[othfi] [numeric](20, 6) NULL,
	[othvd] [numeric](20, 6) NULL,
	[rxvs] [numeric](20, 6) NULL,
	[surgvl4] [numeric](20, 6) NULL,
	[surgvl5] [numeric](20, 6) NULL,
	[radvl4] [numeric](20, 6) NULL,
	[radvl5] [numeric](20, 6) NULL,
	[othvl4] [numeric](20, 6) NULL,
	[othvl5] [numeric](20, 6) NULL,
	[surgimp] [numeric](20, 6) NULL,
	[pt] [varchar](2) NULL,
	[oefoif] [varchar](1) NULL,
	[oefoifdte] [date] NULL,
	[addrgms] [varchar](3) NULL,
	[txsp] [varchar](2) NULL,
	[nsgtot] [numeric](20, 6) NULL,
	[surgtot] [numeric](20, 6) NULL,
	[labtot] [numeric](20, 6) NULL,
	[radtot] [numeric](20, 6) NULL,
	[rxtot] [numeric](20, 6) NULL,
	[othtot] [numeric](20, 6) NULL,
	[totfd] [numeric](20, 6) NULL,
	[totfi] [numeric](20, 6) NULL,
	[totvd] [numeric](20, 6) NULL,
	[totcost] [numeric](20, 6) NULL,
	[prolab] [numeric](20, 6) NULL,
	[prosup] [numeric](20, 6) NULL,
	[dod_flag] [varchar](1) NULL,
	[mpi] [varchar](10) NULL,
	[patcat] [varchar](5) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_DSS_SUA](
	[sta3n] [smallint] NULL,
	[scrssn] [varchar](9) NULL,
	[visn] [tinyint] NULL,
	[sta6a] [varchar](6) NULL,
	[fy] [smallint] NULL,
	[fp] [smallint] NULL,
	[encno] [varchar](11) NULL,
	[date] [date] NULL,
	[timec] [time](0) NULL,
	[inout] [varchar](1) NULL,
	[admitday] [date] NULL,
	[disday] [date] NULL,
	[dob] [date] NULL,
	[sex] [varchar](1) NULL,
	[means] [varchar](2) NULL,
	[zip4] [varchar](10) NULL,
	[enrlp] [varchar](2) NULL,
	[county] [varchar](5) NULL,
	[pct] [varchar](4) NULL,
	[pcp] [varchar](11) NULL,
	[stop] [varchar](3) NULL,
	[divp] [varchar](6) NULL,
	[ipd] [varchar](10) NULL,
	[ip] [int] NULL,
	[fdrloc] [varchar](10) NULL,
	[fdrkey] [varchar](30) NULL,
	[procname] [varchar](25) NULL,
	[volume] [int] NULL,
	[tcost] [numeric](20, 6) NULL,
	[fixdir] [numeric](20, 6) NULL,
	[fixind] [numeric](20, 6) NULL,
	[var] [numeric](20, 6) NULL,
	[vscost] [numeric](20, 6) NULL,
	[vl1cst] [numeric](20, 6) NULL,
	[vl2cst] [numeric](20, 6) NULL,
	[vl4cst] [numeric](20, 6) NULL,
	[vl5cst] [numeric](20, 6) NULL,
	[surgdate] [date] NULL,
	[surgtime] [time](0) NULL,
	[caseno] [int] NULL,
	[surcpt1] [varchar](8) NULL,
	[surg] [bigint] NULL,
	[surpt] [varchar](7) NULL,
	[atdsur] [bigint] NULL,
	[atdsurpt] [varchar](7) NULL,
	[prin] [bigint] NULL,
	[prinpt] [varchar](7) NULL,
	[ansup] [bigint] NULL,
	[snsuppt] [varchar](7) NULL,
	[sspclty] [bigint] NULL,
	[nonorl] [varchar](10) NULL,
	[surcpt2] [varchar](8) NULL,
	[surcpt3] [varchar](8) NULL,
	[surcpt4] [varchar](8) NULL,
	[surcpt5] [varchar](8) NULL,
	[ublt] [varchar](1) NULL,
	[sday] [varchar](1) NULL,
	[csur] [varchar](1) NULL,
	[oefoif] [varchar](1) NULL,
	[oefoifdte] [date] NULL,
	[mpi] [varchar](10) NULL,
	[patcat] [varchar](5) NULL,
	[dod_flag] [varchar](1) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_DSS_SUR](
	[sta3n] [smallint] NULL,
	[scrssn] [varchar](9) NULL,
	[visn] [tinyint] NULL,
	[sta6a] [varchar](6) NULL,
	[fy] [smallint] NULL,
	[fp] [smallint] NULL,
	[encno] [varchar](11) NULL,
	[date] [date] NULL,
	[timec] [time](0) NULL,
	[inout] [varchar](1) NULL,
	[admitday] [date] NULL,
	[disday] [date] NULL,
	[dob] [date] NULL,
	[sex] [varchar](1) NULL,
	[means] [varchar](2) NULL,
	[zip4] [varchar](10) NULL,
	[enrlp] [varchar](2) NULL,
	[county] [varchar](5) NULL,
	[pct] [varchar](4) NULL,
	[pcp] [varchar](11) NULL,
	[stop] [varchar](3) NULL,
	[divp] [varchar](6) NULL,
	[ipd] [varchar](10) NULL,
	[ip] [int] NULL,
	[fdrloc] [varchar](10) NULL,
	[fdrkey] [varchar](30) NULL,
	[procname] [varchar](25) NULL,
	[volume] [int] NULL,
	[tcost] [numeric](20, 6) NULL,
	[fixdir] [numeric](20, 6) NULL,
	[fixind] [numeric](20, 6) NULL,
	[var] [numeric](20, 6) NULL,
	[vscost] [numeric](20, 6) NULL,
	[vl1cst] [numeric](20, 6) NULL,
	[vl2cst] [numeric](20, 6) NULL,
	[vl4cst] [numeric](20, 6) NULL,
	[vl5cst] [numeric](20, 6) NULL,
	[surgdate] [date] NULL,
	[surgtime] [time](0) NULL,
	[caseno] [int] NULL,
	[surcpt1] [varchar](8) NULL,
	[surg] [bigint] NULL,
	[surpt] [varchar](7) NULL,
	[atdsur] [bigint] NULL,
	[atdsurpt] [varchar](7) NULL,
	[prin] [bigint] NULL,
	[prinpt] [varchar](7) NULL,
	[ansup] [bigint] NULL,
	[snsuppt] [varchar](7) NULL,
	[sspclty] [int] NULL,
	[nonorl] [varchar](10) NULL,
	[surcpt2] [varchar](8) NULL,
	[surcpt3] [varchar](8) NULL,
	[surcpt4] [varchar](8) NULL,
	[surcpt5] [varchar](8) NULL,
	[ublt] [varchar](1) NULL,
	[sday] [varchar](1) NULL,
	[csur] [varchar](1) NULL,
	[oefoif] [varchar](1) NULL,
	[oefoifdte] [date] NULL,
	[dod_flag] [varchar](1) NULL,
	[mpi] [varchar](10) NULL,
	[patcat] [varchar](5) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_DSS_TRT](
	[sta3n] [smallint] NULL,
	[scrssn] [varchar](9) NULL,
	[visn] [tinyint] NULL,
	[sta6a] [varchar](6) NULL,
	[fy] [smallint] NULL,
	[fp] [smallint] NULL,
	[encno] [varchar](11) NULL,
	[pcp] [varchar](11) NULL,
	[pcptype] [varchar](7) NULL,
	[admicd9] [varchar](7) NULL,
	[admdrg] [varchar](3) NULL,
	[admitday] [date] NULL,
	[disday] [date] NULL,
	[aggabsdays] [int] NULL,
	[enrpriority] [varchar](2) NULL,
	[sex] [varchar](1) NULL,
	[age] [smallint] NULL,
	[veteran] [varchar](1) NULL,
	[klf] [date] NULL,
	[txsp] [varchar](2) NULL,
	[txspsdt] [date] NULL,
	[txspedt] [date] NULL,
	[txspstm] [time](0) NULL,
	[txspetm] [time](0) NULL,
	[nsgfd] [numeric](20, 6) NULL,
	[nsgfi] [numeric](20, 6) NULL,
	[nsgvd] [numeric](20, 6) NULL,
	[nsgunits] [int] NULL,
	[surgfd] [numeric](20, 6) NULL,
	[surgfi] [numeric](20, 6) NULL,
	[surgvd] [numeric](20, 6) NULL,
	[surgunits] [int] NULL,
	[labfd] [numeric](20, 6) NULL,
	[labfi] [numeric](20, 6) NULL,
	[labvd] [numeric](20, 6) NULL,
	[labunits] [int] NULL,
	[radfd] [numeric](20, 6) NULL,
	[radfi] [numeric](20, 6) NULL,
	[radvd] [numeric](20, 6) NULL,
	[radunits] [int] NULL,
	[rxfd] [numeric](20, 6) NULL,
	[rxfi] [numeric](20, 6) NULL,
	[rxvd] [numeric](20, 6) NULL,
	[othfd] [numeric](20, 6) NULL,
	[othfi] [numeric](20, 6) NULL,
	[othvd] [numeric](20, 6) NULL,
	[rxvs] [numeric](20, 6) NULL,
	[surgvl4] [numeric](20, 6) NULL,
	[surgvl5] [numeric](20, 6) NULL,
	[radvl4] [numeric](20, 6) NULL,
	[radvl5] [numeric](20, 6) NULL,
	[othvl4] [numeric](20, 6) NULL,
	[othvl5] [numeric](20, 6) NULL,
	[surgimp] [numeric](20, 6) NULL,
	[pt] [varchar](2) NULL,
	[oefoif] [varchar](1) NULL,
	[oefoifdte] [date] NULL,
	[addrgms] [smallint] NULL,
	[drgms] [smallint] NULL,
	[los] [int] NULL,
	[nsgtot] [numeric](20, 6) NULL,
	[surgtot] [numeric](20, 6) NULL,
	[labtot] [numeric](20, 6) NULL,
	[radtot] [numeric](20, 6) NULL,
	[rxtot] [numeric](20, 6) NULL,
	[othtot] [numeric](20, 6) NULL,
	[totfd] [numeric](20, 6) NULL,
	[totfi] [numeric](20, 6) NULL,
	[totvd] [numeric](20, 6) NULL,
	[totcost] [numeric](20, 6) NULL,
	[a_pcp] [varchar](11) NULL,
	[a_pcptyp] [varchar](11) NULL,
	[census] [varchar](1) NULL,
	[tao_unt] [int] NULL,
	[thomeox] [numeric](20, 6) NULL,
	[tpha_unt] [int] NULL,
	[tprolbr] [numeric](20, 6) NULL,
	[tprosupl] [numeric](20, 6) NULL,
	[dod_flag] [varchar](1) NULL,
	[mpi] [varchar](10) NULL,
	[opadmit] [varchar](1) NULL,
	[patcat] [varchar](5) NULL,
	[eligibility] [varchar](3) NULL,
	[ps] [varchar](4) NULL,
	[eddisp] [varchar](1) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_DSS_TRTIPD](
	[sta3n] [smallint] NULL,
	[scrssn] [varchar](9) NULL,
	[visn] [tinyint] NULL,
	[sta6a] [varchar](6) NULL,
	[fy] [smallint] NULL,
	[fp] [smallint] NULL,
	[encno] [varchar](11) NULL,
	[txsp] [varchar](2) NULL,
	[txspsdt] [date] NULL,
	[txspedt] [date] NULL,
	[txspstm] [time](0) NULL,
	[txspetm] [time](0) NULL,
	[admitday] [date] NULL,
	[disday] [date] NULL,
	[ipd_fd] [numeric](20, 6) NULL,
	[ipd_fi] [numeric](20, 6) NULL,
	[ipd_vd] [numeric](20, 6) NULL,
	[sum_cv] [int] NULL,
	[suffix] [varchar](6) NULL,
	[oefoif] [varchar](1) NULL,
	[oefoifdte] [date] NULL,
	[ipd_tot] [numeric](20, 6) NULL,
	[ipd_type] [varchar](3) NULL,
	[div] [varchar](3) NULL,
	[ipdbdoc] [int] NULL,
	[ipd] [varchar](10) NULL,
	[wardbdoc] [int] NULL,
	[sta6aipd] [varchar](6) NULL,
	[dod_flag] [varchar](1) NULL,
	[mpi] [varchar](10) NULL,
	[patcat] [varchar](5) NULL,
	[pt] [varchar](2) NULL,
	[eligibility] [varchar](3) NULL,
	[ps] [varchar](4) NULL
) ON [PRIMARY]

GO

CREATE TABLE [MSSR].[MSSR_DSS_WARD](
	[sta3n] [smallint] NULL,
	[scrssn] [varchar](9) NULL,
	[visn] [tinyint] NULL,
	[sta6a] [varchar](6) NULL,
	[fy] [smallint] NULL,
	[fp] [smallint] NULL,
	[encno] [varchar](11) NULL,
	[pcp] [varchar](11) NULL,
	[pcptype] [varchar](7) NULL,
	[admicd9] [varchar](7) NULL,
	[admdrg] [smallint] NULL,
	[admitday] [date] NULL,
	[disday] [date] NULL,
	[aggabsdays] [int] NULL,
	[enrlprty] [varchar](2) NULL,
	[sex] [varchar](1) NULL,
	[age] [smallint] NULL,
	[veteran] [varchar](1) NULL,
	[obs] [varchar](1) NULL,
	[rdt] [date] NULL,
	[ward] [varchar](6) NULL,
	[wrdsdt] [date] NULL,
	[wrdedt] [date] NULL,
	[wrdstm] [time](0) NULL,
	[wrdetm] [time](0) NULL,
	[nsgfd] [numeric](20, 6) NULL,
	[nsgfi] [numeric](20, 6) NULL,
	[nsgvd] [numeric](20, 6) NULL,
	[nsgbdoc] [int] NULL,
	[surgfd] [numeric](20, 6) NULL,
	[surgfi] [numeric](20, 6) NULL,
	[surgvd] [numeric](20, 6) NULL,
	[surgdays] [int] NULL,
	[labfd] [numeric](20, 6) NULL,
	[labfi] [numeric](20, 6) NULL,
	[labvd] [numeric](20, 6) NULL,
	[labtests] [int] NULL,
	[radfd] [numeric](20, 6) NULL,
	[radfi] [numeric](20, 6) NULL,
	[radvd] [numeric](20, 6) NULL,
	[radprocs] [int] NULL,
	[rxfd] [numeric](20, 6) NULL,
	[rxfi] [numeric](20, 6) NULL,
	[rxvd] [numeric](20, 6) NULL,
	[othfd] [numeric](20, 6) NULL,
	[othfi] [numeric](20, 6) NULL,
	[othvd] [numeric](20, 6) NULL,
	[rxvs] [numeric](20, 6) NULL,
	[surgvl4] [numeric](20, 6) NULL,
	[surgvl5] [numeric](20, 6) NULL,
	[radvl4] [numeric](20, 6) NULL,
	[radvl5] [numeric](20, 6) NULL,
	[othvl4] [numeric](20, 6) NULL,
	[othvl5] [numeric](20, 6) NULL,
	[surgimp] [numeric](20, 6) NULL,
	[pt] [varchar](2) NULL,
	[divp] [varchar](6) NULL,
	[ipd] [varchar](7) NULL,
	[oefoif] [varchar](1) NULL,
	[oefoifdte] [date] NULL,
	[addrgms] [varchar](3) NULL,
	[drgms] [smallint] NULL,
	[warddesc] [varchar](20) NULL,
	[quantity] [int] NULL,
	[nsgtot] [numeric](20, 6) NULL,
	[surgtot] [numeric](20, 6) NULL,
	[labtot] [numeric](20, 6) NULL,
	[radtot] [numeric](20, 6) NULL,
	[rxtot] [numeric](20, 6) NULL,
	[othtot] [numeric](20, 6) NULL,
	[totfd] [numeric](20, 6) NULL,
	[totfi] [numeric](20, 6) NULL,
	[totvd] [numeric](20, 6) NULL,
	[totcost] [numeric](20, 6) NULL,
	[produnit] [varchar](8) NULL,
	[ipd_tot] [numeric](20, 6) NULL,
	[ipd_fd] [numeric](20, 6) NULL,
	[ipd_fi] [numeric](20, 6) NULL,
	[ipd_vd] [numeric](20, 6) NULL,
	[prolab] [numeric](20, 6) NULL,
	[prosup] [numeric](20, 6) NULL,
	[sta6p] [varchar](6) NULL,
	[dod_flag] [varchar](1) NULL,
	[mpi] [varchar](10) NULL,
	[patcat] [varchar](5) NULL
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO




